#include <Wire.h>     // inclure la bibliothèque permettant la communication par le protocole I2C
#include "rgb_lcd.h"  // inclure la bibliothèque pour l'écran LCD
 
rgb_lcd lcd;   // création d'un objet lcd
 
float tension, pression;   // Déclaration des variables tension et pression
 
void setup() {
  lcd.begin(16, 2);   // configurer le nombre de colonnes et de lignes de l'écran LCD :
}
 
void loop() {
  tension = analogRead(A0) * 5.0 / 1023.0;   // Lecture de la tension et conversion en V
  pression = tension / 0.0006429 - 311;   // Obtention de la pression en hPa (c'est autre expression de P)
 
  // Affichage de la pression sur l'écran LCD
  lcd.clear();   // effacer l'écran
  lcd.setCursor(0, 0);  // mettre le curseur à la première colonne, première ligne
  lcd.print("U = ");   
  lcd.print(tension,2);   
  lcd.print(" V");
  lcd.setCursor(0, 1);  // mettre le curseur à la première colonne, deuxième ligne
  lcd.print("P = ");   
  lcd.print(pression,0);   
  lcd.print(" hPa");
 
  delay(1000);     //delai de 1000 ms      
}
